﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Winfoot_7_SDK;
using WinfootDefaultPerformancePlugin.Controls.Strategy;

namespace WinfootDefaultPerformancePlugin.Controls
{
    public partial class NtfsDisableLastAccessUpdate : UserControl, ICorrespondenceOS, IControl
    {
        private NtfsDisableLastAccessUpdateController ntfsDisableLastAccessUpdateController;

        public NtfsDisableLastAccessUpdate()
        {
            InitializeComponent();
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                         
#if DEBUG
                                           OS.WindowsSeven
#endif
                                       };
            
        }

        private void groupBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                UserHelp userHelp = new UserHelp(new Uri(@"http://www.migiside.net/wiki/doku.php?id=plugin:performance:ntfsdisablelastaccessupdate"));
                userHelp.Show();
            }
        }

        public void SetNtfsDisableLastAccessUpdateValue(int i)
        {
            checkBox1.Checked = i != 0;
        }


        public int GetNtfsDisableLastAccessUpdateValue()
        {
            return checkBox1.Checked ? 1 : 0;
        }

        #region IControl メンバ

        public void Apply()
        {
            ntfsDisableLastAccessUpdateController.Write();
        }

        public List<WFRegistry> BackUp()
        {
            return ntfsDisableLastAccessUpdateController.BackUp();
        }

        #endregion

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        private void NtfsDisableLastAccessUpdate_Load(object sender, EventArgs e)
        {
            WFUtillity wfUtillity = new WFUtillity();
            ntfsDisableLastAccessUpdateController = new NtfsDisableLastAccessUpdateController(this,
                                                                                      (INtfsDisableLastAccessUpdateStrategy)
                                                                                      wfUtillity.
                                                                                          GetCorrespondenceInstance
                                                                                          (new List<ICorrespondenceOS>
                                                                                               {
                                                                                                   new NtfsDisableLastAccessUpdateDefaultStrategy()
                                                                                               }));
            ntfsDisableLastAccessUpdateController.Read();
        }
    }
}
